<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('favicon.svg')); ?>">
    <?php echo $__env->yieldPushContent('meta'); ?>
    <title><?php echo $__env->yieldContent('title', 'Selinku - Smart Link Management'); ?></title>
    
    <!-- Scripts & Styles -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Outfit', sans-serif; }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-slate-50 text-slate-800 antialiased">
    <!-- Navbar -->
    <nav class="bg-white/80 backdrop-blur-md sticky top-0 z-50 border-b border-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">
                <!-- Logo -->
                <a href="<?php echo e(url('/')); ?>" class="flex items-center gap-2 text-emerald-600 font-bold text-xl">
                    <i class="fa-solid fa-link"></i>
                    <span>Selin<span class="text-slate-800">ku</span></span>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('dashboard')); ?>" class="text-slate-600 hover:text-indigo-600 font-medium transition-colors">Dashboard</a>
                        <form action="<?php echo e(route('logout')); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-slate-600 hover:text-red-600 font-medium transition-colors">
                                Logout
                            </button>
                        </form>
                    <?php endif; ?>
                </div>

                <!-- Mobile Menu Button -->
                <?php if(auth()->guard()->check()): ?>
                <button onclick="document.getElementById('mobileMenu').classList.toggle('hidden')" class="md:hidden text-slate-600 hover:text-indigo-600 p-2">
                    <i class="fa-solid fa-bars text-xl"></i>
                </button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobileMenu" class="hidden md:hidden bg-white border-t border-slate-100 p-4 space-y-3 shadow-lg">
            <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('dashboard')); ?>" class="block text-slate-600 font-medium py-2">Dashboard</a>
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full text-left text-red-600 font-medium py-2">Logout</button>
                </form>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-slate-200 mt-20 pt-12 pb-8">
        <div class="max-w-7xl mx-auto px-4 text-center">
            <p class="text-slate-500 text-sm">&copy; <?php echo e(date('Y')); ?> Selinku. All rights reserved.</p>
        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH D:\LARAVELKU\SHORLINTKU\resources\views/layouts/app.blade.php ENDPATH**/ ?>