<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Primary Meta Tags -->
    <title>{{ $title }}</title>
    <meta name="title" content="{{ $title }}">
    <meta name="description" content="{{ $description }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ $shortlink->getShortUrl() }}">
    <meta property="og:title" content="{{ $title }}">
    <meta property="og:description" content="{{ $description }}">
    @if($image)
    <meta property="og:image" content="{{ $image }}">
    @endif
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ $shortlink->getShortUrl() }}">
    <meta property="twitter:title" content="{{ $title }}">
    <meta property="twitter:description" content="{{ $description }}">
    @if($image)
    <meta property="twitter:image" content="{{ $image }}">
    @endif
    
    <!-- WhatsApp / Telegram -->
    <meta property="og:site_name" content="Selinku">
    
    <!-- NO Auto Redirect - Let bots read meta tags first -->
    
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #059669 0%, #10b981 100%);
            color: white;
            text-align: center;
            padding: 20px;
        }
        .container {
            max-width: 500px;
        }
        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(255,255,255,0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        h1 {
            font-size: 24px;
            margin-bottom: 10px;
        }
        p {
            opacity: 0.9;
            font-size: 16px;
        }
        a {
            color: white;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="spinner"></div>
        <h1>Mengalihkan...</h1>
        <p>Anda akan dialihkan ke halaman tujuan.</p>
        <p style="font-size: 14px; margin-top: 20px;">
            Jika tidak teralihkan otomatis, <a href="{{ $url }}">klik di sini</a>
        </p>
    </div>
    
    <!-- JavaScript Redirect with delay (gives bots time to read meta tags) -->
    <script>
        // Delay redirect by 100ms to allow bots to read meta tags
        // Real users won't notice this tiny delay
        setTimeout(function() {
            window.location.href = "{{ $url }}";
        }, 100);
    </script>
</body>
</html>
