@extends('layouts.dashboard')

@section('title', 'Statistik - Selinku')

@section('content')
<div class="flex flex-col xl:flex-row gap-6">
    <!-- Main Content (Left) -->
    <div class="flex-1 space-y-6 min-w-0">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-slate-900">Analisis Statistik</h2>
                <p class="text-slate-500 mt-1">Pantau performa link dan pengunjung Anda secara real-time</p>
            </div>
            
        </div>

        <!-- Overview Cards -->
        <!-- Overview Cards -->
        <style>
            .scrollbar-hide::-webkit-scrollbar { display: none; }
            .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
        </style>
        
        <div class="relative group sm:block">
            <!-- Nav Buttons (Mobile Only) -->
            <button onclick="scrollStats('left')" class="absolute left-0 top-1/2 -translate-y-1/2 z-10 bg-white/90 backdrop-blur shadow-md border border-slate-100 rounded-full w-8 h-8 flex items-center justify-center text-slate-600 sm:hidden -ml-2 hover:bg-white hover:text-emerald-600 transition-colors">
                <i class="fa-solid fa-chevron-left text-xs"></i>
            </button>
            <button onclick="scrollStats('right')" class="absolute right-0 top-1/2 -translate-y-1/2 z-10 bg-white/90 backdrop-blur shadow-md border border-slate-100 rounded-full w-8 h-8 flex items-center justify-center text-slate-600 sm:hidden -mr-2 hover:bg-white hover:text-emerald-600 transition-colors">
                <i class="fa-solid fa-chevron-right text-xs"></i>
            </button>

            <!-- Scrollable Container -->
            <div id="statsContainer" class="flex overflow-x-auto snap-x snap-mandatory gap-4 px-1 py-1 sm:grid sm:grid-cols-2 lg:grid-cols-4 sm:overflow-visible sm:p-0 scrollbar-hide scroll-smooth">
                <!-- Total Clicks -->
                <div class="min-w-[85%] sm:min-w-0 snap-center bg-white p-5 rounded-xl border border-slate-200 shadow-sm shrink-0">
                    <div class="flex items-center gap-4">
                        <div class="bg-indigo-50 p-3 rounded-xl text-indigo-600 shrink-0">
                            <i class="fa-solid fa-mouse-pointer text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-slate-900 leading-none">{{ number_format($stats['total_clicks']) }}</h3>
                            <p class="text-xs text-slate-500 mt-1">Total Klik</p>
                        </div>
                    </div>
                </div>

                <!-- Unique Visitors -->
                <div class="min-w-[85%] sm:min-w-0 snap-center bg-white p-5 rounded-xl border border-slate-200 shadow-sm shrink-0">
                    <div class="flex items-center gap-4">
                        <div class="bg-green-50 p-3 rounded-xl text-green-600 shrink-0">
                            <i class="fa-solid fa-users text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-slate-900 leading-none">{{ number_format($stats['unique_clicks']) }}</h3>
                            <p class="text-xs text-slate-500 mt-1">Pengunjung Unik</p>
                        </div>
                    </div>
                </div>

                <!-- Avg Clicks -->
                <div class="min-w-[85%] sm:min-w-0 snap-center bg-white p-5 rounded-xl border border-slate-200 shadow-sm shrink-0">
                    <div class="flex items-center gap-4">
                        <div class="bg-blue-50 p-3 rounded-xl text-blue-600 shrink-0">
                            <i class="fa-solid fa-chart-pie text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-slate-900 leading-none">{{ $stats['avg_clicks'] }}</h3>
                            <p class="text-xs text-slate-500 mt-1">Rata-rata Klik / Link</p>
                        </div>
                    </div>
                </div>

                <!-- Total Links -->
                <div class="min-w-[85%] sm:min-w-0 snap-center bg-white p-5 rounded-xl border border-slate-200 shadow-sm shrink-0">
                    <div class="flex items-center gap-4">
                        <div class="bg-emerald-50 p-3 rounded-xl text-emerald-600 shrink-0">
                            <i class="fa-solid fa-link text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-slate-900 leading-none">{{ number_format($stats['total_links']) }}</h3>
                            <p class="text-xs text-slate-500 mt-1">Total Link Dibuat</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script>
            function scrollStats(direction) {
                const container = document.getElementById('statsContainer');
                const scrollAmount = container.offsetWidth * 0.85; // Scroll 1 card width
                
                if (direction === 'left') {
                    container.scrollLeft -= scrollAmount;
                } else {
                    container.scrollLeft += scrollAmount;
                }
            }
        </script>

        <!-- Main Chart -->
        <!-- Main Chart -->
        <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm">
            <div class="flex items-center justify-between mb-6">
                <h3 class="font-semibold text-slate-800">Trafik Kunjungan</h3>
                <form action="{{ route('analytics.index') }}" method="GET">
                    <select name="period" onchange="this.form.submit()" class="bg-slate-50 border border-slate-200 text-slate-700 text-sm rounded-lg focus:ring-emerald-500 focus:border-emerald-500 block p-2 outline-none cursor-pointer">
                        <option value="today" {{ request('period') == 'today' ? 'selected' : '' }}>Hari Ini (24 Jam)</option>
                        <option value="7days" {{ request('period') == '7days' ? 'selected' : '' }}>7 Hari Terakhir</option>
                        <option value="30days" {{ request('period', '30days') == '30days' ? 'selected' : '' }}>30 Hari Terakhir</option>
                        <option value="all" {{ request('period') == 'all' ? 'selected' : '' }}>Semua Waktu (12 Bulan)</option>
                    </select>
                </form>
            </div>
            <div class="h-72 w-full">
                <canvas id="mainChart"></canvas>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 items-start">
            <!-- Device & OS Stats -->
            <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm transition-all duration-300">
                <div class="flex items-center justify-between mb-4 cursor-pointer lg:cursor-default" onclick="toggleSection('stats-content', 'stats-icon')">
                    <h3 class="font-semibold text-slate-800">Perangkat & Sistem Operasi</h3>
                    <button class="lg:hidden text-slate-400 hover:text-emerald-600 transition-colors">
                        <i id="stats-icon" class="fa-solid fa-chevron-down transition-transform duration-300"></i>
                    </button>
                </div>
                <div id="stats-content" class="hidden lg:block space-y-4">
                    <!-- Device Type -->
                    <div>
                        <h4 class="text-xs font-semibold text-slate-400 uppercase tracking-wider mb-2">Perangkat</h4>
                        <div class="space-y-2 pr-2">
                            @foreach($devices->take(3) as $device)
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-emerald-50 flex items-center justify-center text-emerald-600 shrink-0">
                                        @php $devType = strtolower($device->device_type); @endphp
                                        <i class="fa-solid fa-{{ $devType === 'mobile' ? 'mobile' : ($devType === 'tablet' ? 'tablet-screen-button' : 'desktop') }}"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">{{ $device->device_type }}</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-emerald-500 rounded-full" style="width: {{ $device->percentage ?? 0 }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($device->percentage ?? 0) }}%</span>
                                </div>
                            </div>
                            @endforeach

                            @if($devices->count() > 3)
                            @php
                                $otherPercentage = $devices->skip(3)->sum('percentage');
                            @endphp
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-emerald-50 flex items-center justify-center text-emerald-600 shrink-0">
                                        <i class="fa-solid fa-layer-group"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">Sumber lainnya</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-emerald-500 rounded-full" style="width: {{ $otherPercentage }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($otherPercentage) }}%</span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="border-t border-slate-100 pt-4"></div>

                    <!-- OS -->
                    <div>
                        <h4 class="text-xs font-semibold text-slate-400 uppercase tracking-wider mb-2">Sistem Operasi</h4>
                        <div class="space-y-2 pr-2">
                            @foreach($os->take(3) as $system)
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-50 flex items-center justify-center text-blue-600 shrink-0">
                                        @php
                                            $osName = strtolower($system->os);
                                            $osIcon = 'fa-microchip';
                                            if (str_contains($osName, 'windows')) $osIcon = 'fa-brands fa-windows';
                                            elseif (str_contains($osName, 'android')) $osIcon = 'fa-brands fa-android';
                                            elseif (str_contains($osName, 'linux')) $osIcon = 'fa-brands fa-linux';
                                            elseif (str_contains($osName, 'ios') || str_contains($osName, 'mac')) $osIcon = 'fa-brands fa-apple';
                                            elseif (str_contains($osName, 'ubuntu')) $osIcon = 'fa-brands fa-ubuntu';
                                            else $osIcon = 'fa-solid ' . $osIcon;
                                        @endphp
                                        <i class="{{ str_starts_with($osIcon, 'fa-') ? $osIcon : 'fa-solid '.$osIcon }}"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">{{ $system->os }}</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-blue-500 rounded-full" style="width: {{ $system->percentage ?? 0 }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($system->percentage ?? 0) }}%</span>
                                </div>
                            </div>
                            @endforeach

                            @if($os->count() > 3)
                            @php
                                $otherPercentage = $os->skip(3)->sum('percentage');
                            @endphp
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-blue-50 flex items-center justify-center text-blue-600 shrink-0">
                                        <i class="fa-solid fa-layer-group"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">Sumber lainnya</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-blue-500 rounded-full" style="width: {{ $otherPercentage }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($otherPercentage) }}%</span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="border-t border-slate-100 pt-4"></div>

                    <!-- Country -->
                    <div>
                        <h4 class="text-xs font-semibold text-slate-400 uppercase tracking-wider mb-2">Negara</h4>
                        <div class="space-y-2 pr-2">
                            @forelse($countries->take(3) as $country)
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-indigo-50 flex items-center justify-center text-indigo-600 shrink-0">
                                        <i class="fa-solid fa-globe"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">{{ $country->country ?: 'Local' }}</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-indigo-500 rounded-full" style="width: {{ $country->percentage ?? 0 }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($country->percentage ?? 0) }}%</span>
                                </div>
                            </div>
                            @empty
                            <p class="text-xs text-slate-400 italic">Belum ada data negara</p>
                            @endforelse

                            @if($countries->count() > 3)
                            @php
                                $otherPercentage = $countries->skip(3)->sum('percentage');
                            @endphp
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-indigo-50 flex items-center justify-center text-indigo-600 shrink-0">
                                        <i class="fa-solid fa-layer-group"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">Sumber lainnya</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-indigo-500 rounded-full" style="width: {{ $otherPercentage }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($otherPercentage) }}%</span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="border-t border-slate-100 pt-4"></div>

                    <!-- City -->
                    <div>
                        <h4 class="text-xs font-semibold text-slate-400 uppercase tracking-wider mb-2">Kota</h4>
                        <div class="space-y-2 pr-2">
                            @forelse($cities->take(3) as $city)
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-purple-50 flex items-center justify-center text-purple-600 shrink-0">
                                        <i class="fa-solid fa-location-dot"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700 cursor-help" title="{{ $city->city ?: 'Local' }}">{{ $city->city ?: 'Local' }}</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-purple-500 rounded-full" style="width: {{ $city->percentage ?? 0 }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($city->percentage ?? 0) }}%</span>
                                </div>
                            </div>
                            @empty
                            <p class="text-xs text-slate-400 italic">Belum ada data kota</p>
                            @endforelse

                            @if($cities->count() > 3)
                            @php
                                $otherPercentage = $cities->skip(3)->sum('percentage');
                            @endphp
                            <div class="flex items-center justify-between text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 rounded-lg bg-purple-50 flex items-center justify-center text-purple-600 shrink-0">
                                        <i class="fa-solid fa-layer-group"></i>
                                    </div>
                                    <span class="capitalize font-medium text-slate-700">Sumber lainnya</span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="w-16 h-2 bg-slate-100 rounded-full overflow-hidden">
                                        <div class="h-full bg-purple-500 rounded-full" style="width: {{ $otherPercentage }}%"></div>
                                    </div>
                                    <span class="font-medium text-slate-700 w-8 text-right">{{ round($otherPercentage) }}%</span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Performing Links -->
            <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm transition-all duration-300">
                <div class="flex items-center justify-between mb-4 cursor-pointer lg:cursor-default" onclick="toggleSection('links-content', 'links-icon')">
                    <h3 class="font-semibold text-slate-800">Link Terpopuler</h3>
                    <button class="lg:hidden text-slate-400 hover:text-emerald-600 transition-colors">
                        <i id="links-icon" class="fa-solid fa-chevron-down transition-transform duration-300"></i>
                    </button>
                </div>
                
                <div id="links-content" class="hidden lg:block space-y-4">
                    @forelse($topLinks as $link)
                    <div onclick="openLinkDetails('{{ $link->custom_alias ?: $link->short_code }}', '{{ $link->original_url }}', {{ $link->clicks_count }}, {{ $link->unique_clicks_count }}, {{ $link->clicks_30_days_count }}, {{ $link->clicks_7_days_count }}, {{ $link->clicks_today_count }}, '{{ $link->clicks->first() ? $link->clicks->first()->clicked_at->diffForHumans() : 'Belum pernah' }}', '{{ $link->top_referrer }}', '{{ $link->latest_referrer }}', {{ json_encode($link->referrer_summary) }}, {{ $link->clicks_1_hour_count }}, '{{ $link->top_device }}', '{{ $link->top_os }}', '{{ $link->top_country }}', '{{ $link->top_city }}', {{ $link->top_device_count }}, {{ $link->top_os_count }}, {{ $link->top_country_count }}, {{ $link->top_city_count }})" 
                         class="p-4 rounded-lg border border-slate-100 hover:border-emerald-100 hover:bg-slate-50 transition-colors cursor-pointer group">
                        <div class="flex justify-between items-start mb-2">
                            <span class="font-medium text-emerald-600 group-hover:text-emerald-700 truncate pr-4 max-w-[150px]">
                                {{ $link->custom_alias ?: $link->short_code }}
                            </span>
                            <span class="text-sm font-bold text-slate-700">{{ number_format($link->clicks_count) }} <span class="text-xs font-normal text-slate-500">klik</span></span>
                        </div>
                        <p class="text-xs text-slate-500 truncate mb-2">{{ $link->original_url }}</p>
                        <div class="w-full h-1.5 bg-slate-100 rounded-full overflow-hidden">
                            <div class="h-full bg-emerald-500 rounded-full" style="width: {{ $stats['total_clicks'] > 0 ? ($link->clicks_count / $stats['total_clicks']) * 100 : 0 }}%"></div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-10 text-slate-400">
                        <i class="fa-solid fa-chart-bar text-4xl mb-3 opacity-50"></i>
                        <p>Belum ada data statistik</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar -->
    <div class="w-full xl:w-80 space-y-6">
        <!-- Today's Insights Card -->
        <div class="bg-emerald-600 text-white p-6 rounded-xl shadow-lg relative overflow-hidden">
            <!-- Decorative circles -->
            <div class="absolute top-0 right-0 -mr-4 -mt-4 w-24 h-24 rounded-full bg-white opacity-10 blur-xl"></div>
            <div class="absolute bottom-0 left-0 -ml-4 -mb-4 w-20 h-20 rounded-full bg-white opacity-10 blur-lg"></div>
            
            <h3 class="font-bold text-lg mb-1 relative z-10">Insights Hari Ini</h3>
            <p class="text-emerald-100 text-sm mb-6 relative z-10">{{ now()->format('d M Y') }}</p>

            <div class="space-y-6 relative z-10">
                <div class="flex items-center gap-4">
                    <div class="w-10 h-10 rounded-lg bg-white/20 flex items-center justify-center text-white backdrop-blur-sm">
                        <i class="fa-solid fa-arrow-pointer"></i>
                    </div>
                    <div>
                        <p class="text-2xl font-bold">{{ number_format($todayStats['clicks']) }}</p>
                        <p class="text-xs text-emerald-100">Klik Hari Ini</p>
                    </div>
                </div>

                <div class="flex items-center gap-4">
                    <div class="w-10 h-10 rounded-lg bg-white/20 flex items-center justify-center text-white backdrop-blur-sm">
                        <i class="fa-solid fa-user-check"></i>
                    </div>
                    <div>
                        <p class="text-2xl font-bold">{{ number_format($todayStats['unique_visitors']) }}</p>
                        <p class="text-xs text-emerald-100">Pengunjung Unik</p>
                    </div>
                </div>
            </div>

            @if($todayStats['top_link_today'])
            <div class="mt-6 pt-6 border-t border-emerald-500/50 relative z-10">
                <p class="text-xs font-medium text-emerald-200 uppercase tracking-wider mb-3">Trending Hari Ini</p>
                <div class="bg-white/10 p-3 rounded-lg backdrop-blur-sm border border-white/10">
                    <a href="{{ route('shortlinks.index', ['search' => $todayStats['top_link_today']->custom_alias ?: $todayStats['top_link_today']->short_code]) }}" class="block font-medium text-white truncate hover:text-emerald-100 transition-colors">
                        {{ $todayStats['top_link_today']->custom_alias ?: $todayStats['top_link_today']->short_code }}
                    </a>
                    <div class="flex items-center justify-between mt-2 text-xs text-emerald-100">
                        <span>{{ number_format($todayStats['top_link_today']->clicks_count) }} klik</span>
                        <i class="fa-solid fa-arrow-trend-up"></i>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Quick Tips or Promo -->
        <!-- Smart Insight -->
        <!-- Smart Insight (Sticky Note Style - Gray) -->
        <div class="bg-gray-50 text-slate-800 p-6 rounded-xl shadow-sm border border-gray-200 relative overflow-hidden">
            <div class="absolute top-0 right-0 w-8 h-8 bg-gray-100 rounded-bl-xl"></div>
            
            <div class="flex items-start gap-4 relative z-10">
                <div class="p-2.5 bg-gray-200 text-gray-600 rounded-lg shrink-0">
                    <i class="fa-solid fa-lightbulb text-lg"></i>
                </div>
                <div>
                    <h4 class="font-bold text-sm mb-2 text-slate-900">Smart Insight</h4>
                    <div class="text-xs text-slate-700 leading-relaxed space-y-2">
                        {!! $insightText !!}
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities Feed -->
        <div class="bg-white p-6 rounded-xl border border-slate-200 shadow-sm">
            <h3 class="font-bold text-slate-800 mb-4 flex items-center gap-2">
                <i class="fa-solid fa-clock-rotate-left text-emerald-500"></i>
                Aktivitas Terbaru
            </h3>
            <div class="space-y-4 max-h-[500px] overflow-y-auto pr-2">
                @forelse($recentActivities as $activity)
                <div class="flex items-start gap-3 relative pb-4 border-b border-slate-50 last:border-0 last:pb-0">
                    <div class="mt-1">
                        @if($activity->device_type == 'mobile')
                            <i class="fa-solid fa-mobile-screen text-slate-400 text-xs"></i>
                        @elseif($activity->device_type == 'tablet')
                            <i class="fa-solid fa-tablet-screen-button text-slate-400 text-xs"></i>
                        @else
                            <i class="fa-solid fa-desktop text-slate-400 text-xs"></i>
                        @endif
                    </div>
                    <div class="flex-1 min-w-0">
                        <a href="{{ route('shortlinks.index', ['search' => $activity->shortlink->custom_alias ?: $activity->shortlink->short_code]) }}" class="text-xs font-medium text-slate-800 truncate hover:text-emerald-600 transition-colors block">
                            {{ $activity->shortlink->title ?: ($activity->shortlink->custom_alias ?: $activity->shortlink->short_code) }}
                        </a>
                        <div class="flex items-center flex-wrap gap-2 mt-1">
                            <span class="text-[10px] px-1.5 py-0.5 bg-slate-100 text-slate-500 rounded border border-slate-200">{{ $activity->browser ?: 'Unknown' }}</span>
                            <span class="text-[10px] text-slate-400 flex items-center gap-1">
                                <i class="fa-solid fa-link text-slate-300 text-[9px]"></i>
                                {{ $activity->referer_url ? parse_url($activity->referer_url, PHP_URL_HOST) : 'Direct' }}
                            </span>
                        </div>
                        <div class="flex items-center flex-wrap gap-2 mt-1">
                            <span class="text-[10px] text-slate-400 flex items-center gap-1">
                                <i class="fa-solid fa-network-wired text-slate-300 text-[9px]"></i>
                                {{ $activity->ip_address }}
                            </span>
                            @if($activity->country)
                                @if($activity->country === 'Local')
                                <span class="text-[10px] px-1.5 py-0.5 bg-slate-100 text-slate-600 rounded border border-slate-200 flex items-center gap-1">
                                    <i class="fa-solid fa-laptop text-[9px]"></i>
                                    {{ $activity->country }}
                                </span>
                                @elseif($activity->country === 'Unknown')
                                <span class="text-[10px] px-1.5 py-0.5 bg-orange-50 text-orange-600 rounded border border-orange-200 flex items-center gap-1">
                                    <i class="fa-solid fa-question text-[9px]"></i>
                                    {{ $activity->country }}
                                </span>
                                @else
                                <span class="text-[10px] px-1.5 py-0.5 bg-blue-50 text-blue-600 rounded border border-blue-200 flex items-center gap-1">
                                    <i class="fa-solid fa-globe text-[9px]"></i>
                                    {{ $activity->country }}
                                </span>
                                @endif
                            @endif
                            <span class="text-[10px] text-slate-400 ml-auto">{{ $activity->clicked_at->diffForHumans(null, true) }}</span>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-4 text-slate-400 text-xs italic">
                    Belum ada aktivitas klik.
                </div>
                @endforelse
            </div>
        </div>
    </div>
<!-- Link Details Modal -->
<div id="linkDetailsModal" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Overlay -->
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true" onclick="closeLinkDetails()"></div>

        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

        <!-- Modal Panel -->
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                <div class="sm:flex sm:items-start">
                    <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-emerald-100 sm:mx-0 sm:h-10 sm:w-10">
                        <i class="fa-solid fa-chart-line text-emerald-600"></i>
                    </div>
                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                        <h3 class="text-lg leading-6 font-medium text-slate-900" id="modalLinkTitle">
                            Link Details
                        </h3>
                        <div class="mt-2">
                            <p class="text-sm text-slate-500 break-all mb-4" id="modalOriginalUrl">
                                https://example.com/very-long-url...
                            </p>
                            
                            <!-- Stats Grid -->
                            <div class="grid grid-cols-2 gap-4 mt-4">
                                <!-- Today -->
                                <div class="bg-emerald-50 p-3 rounded-lg border border-emerald-100">
                                    <span class="block text-xs font-medium text-emerald-500 uppercase">Hari Ini</span>
                                    <span class="block text-xl font-bold text-emerald-700" id="modalClicksToday">0</span>
                                    <span class="text-xs text-emerald-400">klik</span>
                                </div>
                                
                                <!-- 7 Days -->
                                <div class="bg-slate-50 p-3 rounded-lg border border-slate-100">
                                    <span class="block text-xs font-medium text-slate-500 uppercase">7 Hari Terakhir</span>
                                    <span class="block text-xl font-bold text-slate-700" id="modalClicks7Days">0</span>
                                    <span class="text-xs text-slate-400">klik</span>
                                </div>

                                <!-- 30 Days -->
                                <div class="bg-slate-50 p-3 rounded-lg border border-slate-100">
                                    <span class="block text-xs font-medium text-slate-500 uppercase">30 Hari Terakhir</span>
                                    <span class="block text-xl font-bold text-slate-700" id="modalClicks30Days">0</span>
                                    <span class="text-xs text-slate-400">klik</span>
                                </div>

                                <!-- Total -->
                                <div class="bg-green-50 p-3 rounded-lg border border-green-100">
                                    <span class="block text-xs font-medium text-green-600 uppercase">Total (All Time)</span>
                                    <span class="block text-xl font-bold text-green-700" id="modalTotalClicks">0</span>
                                    <span class="text-xs text-green-500" id="modalUniqueClicks">(0 Unik)</span>
                                </div>
                            </div>

                            <!-- Referrer Info -->
                            <div class="mt-4 pt-4 border-t border-slate-100">
                                <h4 class="text-xs font-semibold text-slate-500 uppercase mb-3">Sumber Terpopuler</h4>
                                <div id="modalReferrerList" class="space-y-2 max-h-40 overflow-y-auto pr-1"></div>
                                
                                <!-- Latest Referrer Only -->
                                <div class="mt-4 pt-4 border-t border-slate-100">
                                    <span class="block text-xs font-medium text-slate-500 uppercase mb-2">Sumber Terbaru</span>
                                    <div class="flex items-center gap-2">
                                        <i class="fa-regular fa-clock text-blue-500 text-sm"></i>
                                        <span class="text-sm font-semibold text-slate-800 truncate" id="modalLatestReferrer">-</span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Popular Stats (Device, OS, Country, City) -->
                            <div class="mt-4 pt-4 border-t border-slate-100">
                                <h4 class="text-xs font-semibold text-slate-600 uppercase mb-3">Statistik Populer (Sepanjang Masa)</h4>
                                <div class="grid grid-cols-2 gap-4">
                                    <!-- Device -->
                                    <div>
                                        <span class="block text-xs font-medium text-slate-500 uppercase mb-1">Perangkat</span>
                                        <div class="flex items-center gap-2">
                                            <i class="fa-solid fa-desktop text-emerald-500 text-sm"></i>
                                            <span class="text-sm font-semibold text-slate-800 truncate capitalize" id="modalTopDevice">-</span>
                                        </div>
                                    </div>
                                    
                                    <!-- OS -->
                                    <div>
                                        <span class="block text-xs font-medium text-slate-500 uppercase mb-1">Sistem Operasi</span>
                                        <div class="flex items-center gap-2">
                                            <i class="fa-brands fa-windows text-blue-500 text-sm"></i>
                                            <span class="text-sm font-semibold text-slate-800 truncate capitalize" id="modalTopOS">-</span>
                                        </div>
                                    </div>
                                    
                                    <!-- Country -->
                                    <div>
                                        <span class="block text-xs font-medium text-slate-500 uppercase mb-1">Negara</span>
                                        <div class="flex items-center gap-2">
                                            <i class="fa-solid fa-globe text-indigo-500 text-sm"></i>
                                            <span class="text-sm font-semibold text-slate-800 truncate capitalize" id="modalTopCountry">-</span>
                                        </div>
                                    </div>
                                    
                                    <!-- City -->
                                    <div>
                                        <span class="block text-xs font-medium text-slate-500 uppercase mb-1">Kota</span>
                                        <div class="flex items-center gap-2">
                                            <i class="fa-solid fa-map-marker-alt text-purple-500 text-sm"></i>
                                            <span class="text-sm font-semibold text-slate-800 truncate capitalize cursor-help" id="modalTopCity" title="">-</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-6 pt-4 border-t border-slate-100 space-y-2">
                                <div class="text-xs text-slate-500" id="modalLastClick">Terakhir diklik: Baru saja</div>
                                <div id="modalClicks1Hour" class="text-xs text-slate-500 hidden"></div>
                            </div>
                            
                            <div class="mt-6 pt-4 border-t border-slate-100 text-center">
                                <a id="modalDetailedAnalyticsBtn" href="#" class="text-emerald-600 hover:text-emerald-700 font-medium text-sm flex items-center justify-center gap-2">
                                    Rincian Selengkapnya <i class="fa-solid fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                <button type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-slate-700 hover:bg-slate-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm" onclick="closeLinkDetails()">
                    Tutup
                </button>
            </div>
        </div>
    </div>
</div>
</div> 

<script>
    function openLinkDetails(title, url, total, unique, d30, d7, today, last, topRef, latestRef, referrerList, c1h, topDevice, topOS, topCountry, topCity, topDeviceCount, topOSCount, topCountryCount, topCityCount) {
        document.getElementById('modalLinkTitle').innerText = title;
        document.getElementById('modalOriginalUrl').innerText = url;
        document.getElementById('modalTotalClicks').innerText = total;
        document.getElementById('modalUniqueClicks').innerText = '(' + unique + ' Unik)';
        document.getElementById('modalClicks30Days').innerText = d30;
        document.getElementById('modalClicks7Days').innerText = d7;
        document.getElementById('modalClicksToday').innerText = today;
        document.getElementById('modalLastClick').innerText = 'Terakhir diklik: ' + last;
        
        // 1 Hour Clicks
        const c1hEl = document.getElementById('modalClicks1Hour');
        if (c1h > 0) {
            c1hEl.innerText = 'Klik dalam 1 jam: ' + c1h + ' kali';
            c1hEl.classList.remove('hidden');
        } else {
            c1hEl.classList.add('hidden');
        }
        
        // Set Detailed Analytics Link
        document.getElementById('modalDetailedAnalyticsBtn').href = "{{ route('analytics.data') }}?search=" + encodeURIComponent(title);
        
        // Referrer List
        const listContainer = document.getElementById('modalReferrerList');
        listContainer.innerHTML = ''; 

        if (referrerList && referrerList.length > 0) {
            referrerList.forEach(item => {
                const domain = item.source;
                const count = item.count;
                const htmlItem = `
                    <div class="flex justify-between items-center text-sm">
                        <div class="flex items-center gap-2">
                            <span class="text-slate-700 font-medium truncate max-w-[150px]">${domain}</span>
                        </div>
                        <span class="bg-slate-100 text-slate-600 px-2 py-0.5 rounded-full text-xs font-bold">${count} klik</span>
                    </div>`;
                listContainer.insertAdjacentHTML('beforeend', htmlItem);
            });
        } else {
            listContainer.innerHTML = '<p class="text-sm text-slate-400 italic text-center">Belum ada data</p>';
        }
        
        // Latest Referrer Only
        document.getElementById('modalLatestReferrer').innerText = latestRef || '-';
        // Note: modalTopReferrer element was removed from HTML
        
        // Popular Stats with Counts
        document.getElementById('modalTopDevice').innerHTML = (topDevice && topDevice !== '-') ? `${topDevice} <span class="text-slate-400 font-normal text-xs ml-1">(${topDeviceCount} klik)</span>` : '-';
        document.getElementById('modalTopOS').innerHTML = (topOS && topOS !== '-') ? `${topOS} <span class="text-slate-400 font-normal text-xs ml-1">(${topOSCount} klik)</span>` : '-';
        document.getElementById('modalTopCountry').innerHTML = (topCountry && topCountry !== '-') ? `${topCountry} <span class="text-slate-400 font-normal text-xs ml-1">(${topCountryCount} klik)</span>` : '-';
        
        // City with tooltip
        const cityElement = document.getElementById('modalTopCity');
        cityElement.innerHTML = (topCity && topCity !== '-') ? `${topCity} <span class="text-slate-400 font-normal text-xs ml-1">(${topCityCount} klik)</span>` : '-';
        cityElement.setAttribute('title', topCity && topCity !== '-' ? topCity : '');
        
        document.getElementById('linkDetailsModal').classList.remove('hidden');
    }

    function closeLinkDetails() {
        document.getElementById('linkDetailsModal').classList.add('hidden');
    }
</script>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Main Chart Configuration
    const ctx = document.getElementById('mainChart').getContext('2d');
    
    // Gradient for the chart
    const gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(16, 185, 129, 0.2)');
    gradient.addColorStop(1, 'rgba(16, 185, 129, 0)');

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: {!! json_encode($labels) !!},
            datasets: [{
                label: 'Klik',
                data: {!! json_encode($chartData) !!},
                borderColor: '#10b981',
                backgroundColor: gradient,
                borderWidth: 2,
                pointBackgroundColor: '#ffffff',
                pointBorderColor: '#10b981',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: '#1e293b',
                    padding: 12,
                    titleFont: {
                        size: 13,
                        family: "'Inter', sans-serif"
                    },
                    bodyFont: {
                        size: 13,
                        family: "'Inter', sans-serif"
                    },
                    cornerRadius: 8,
                    displayColors: false,
                    intersect: false,
                    mode: 'index',
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        display: true,
                        borderDash: [5, 5],
                        color: '#f1f5f9',
                    },
                    ticks: {
                        color: '#64748b',
                        font: {
                            family: "'Inter', sans-serif",
                            size: 11
                        }
                    } 
                },
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: '#64748b',
                        maxTicksLimit: 10,
                        font: {
                            family: "'Inter', sans-serif",
                            size: 11
                        }
                    }
                }
            },
            interaction: {
                intersect: false,
                mode: 'index',
            },
        }
    });
</script>
@endpush

<script>
    function toggleSection(contentId, iconId) {
        // Only run regarding mobile logic checking, but here we just toggle class
        // Check if we are on mobile view implicitly by the class state
        if (window.innerWidth >= 1024) return; // Prevent toggle on desktop if desired

        const content = document.getElementById(contentId);
        const icon = document.getElementById(iconId);
        
        if (content.classList.contains('hidden')) {
            content.classList.remove('hidden');
            icon.classList.add('rotate-180');
        } else {
            content.classList.add('hidden');
            icon.classList.remove('rotate-180');
        }
    }
</script>
@endsection
