<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pemeriksaan Keamanan - Selinku</title>
    <!-- CDN Assets for Standalone Page -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Outfit', sans-serif; }
    </style>
</head>
<body class="bg-slate-50 min-h-screen flex items-center justify-center p-4">

    <div class="max-w-md w-full bg-white rounded-2xl shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 p-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="w-16 h-16 bg-blue-50 rounded-2xl flex items-center justify-center mx-auto mb-4 transform rotate-3 shadow-sm border border-blue-100">
                <i class="fa-solid fa-shield-cat text-2xl text-blue-600 transform -rotate-3"></i>
            </div>
            <h1 class="text-2xl font-bold text-slate-800 mb-2">Pemeriksaan Keamanan</h1>
            <p class="text-slate-500 text-sm">Demi keamanan akun, silakan jawab pertanyaan keamanan yang telah Anda atur.</p>
        </div>

        <div class="bg-slate-50 border border-slate-200 rounded-xl p-5 mb-8 relative overflow-hidden group">
            <div class="absolute -right-4 -top-4 w-16 h-16 bg-blue-100 rounded-full opacity-20 group-hover:scale-150 transition-transform duration-500"></div>
            <p class="text-xs font-bold text-blue-600 uppercase tracking-wider mb-2 flex items-center gap-2">
                <i class="fa-solid fa-circle-question"></i> Pertanyaan Anda
            </p>
            <p class="text-lg font-bold text-slate-800 leading-snug">"{{ $question }}"</p>
        </div>

        <form action="{{ route('login.challenge.post') }}" method="POST" class="space-y-5">
            @csrf
            
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Jawaban Anda</label>
                <div class="relative group">
                    <span class="absolute left-4 top-3.5 text-slate-400 group-focus-within:text-blue-500 transition-colors">
                        <i class="fa-solid fa-pen-nib"></i>
                    </span>
                    <input type="text" name="security_answer" class="w-full pl-11 pr-4 py-3 bg-white border border-slate-200 rounded-xl focus:outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all text-slate-800 placeholder:text-slate-400 font-medium shadow-sm" placeholder="Ketik jawaban..." required autofocus autocomplete="off">
                </div>
                @error('security_answer')
                    <p class="mt-2 text-xs text-red-500 flex items-center gap-1 font-medium bg-red-50 px-2 py-1 rounded w-fit">
                        <i class="fa-solid fa-circle-exclamation"></i> {{ $message }}
                    </p>
                @enderror
                <p class="text-[10px] text-slate-400 mt-2 ml-1">
                    <i class="fa-solid fa-info-circle mr-0.5"></i> Tidak case-sensitive (huruf besar/kecil dianggap sama).
                </p>
            </div>

            <button type="submit" class="w-full bg-slate-900 hover:bg-slate-800 text-white font-bold py-3.5 rounded-xl shadow-lg shadow-slate-900/10 hover:shadow-slate-900/20 active:scale-[0.98] transition-all duration-200 flex items-center justify-center gap-2">
                Verifikasi Jawaban <i class="fa-solid fa-arrow-right opacity-60"></i>
            </button>
        </form>

        <div class="mt-8 text-center pt-6 border-t border-slate-50">
            <form action="{{ route('logout') }}" method="POST">
                @csrf
                <button type="submit" class="text-sm font-medium text-slate-500 hover:text-red-500 transition-colors flex items-center justify-center gap-2 mx-auto group">
                    <i class="fa-solid fa-arrow-left group-hover:-translate-x-1 transition-transform"></i> Kembali ke Login
                </button>
            </form>
        </div>
    </div>
    
    <!-- Footer Credit -->
    <div class="fixed bottom-6 w-full text-center text-[10px] text-slate-400 font-medium">
        &copy; {{ date('Y') }} Selinku Security System
    </div>

</body>
</html>
