<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Cek apakah user sudah ada
        $existingUser = User::where('email', 'admin@selinku.com')->first();
        
        if ($existingUser) {
            $this->command->info('User admin@selinku.com sudah ada!');
            return;
        }

        // Buat user baru
        User::create([
            'name' => 'Admin Selinku',
            'email' => 'admin@selinku.com',
            'password' => Hash::make('password'),
        ]);

        $this->command->info('User admin@selinku.com berhasil dibuat!');
    }
}
