<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // System Integrity Check
        // Ensures attribution remains intact
        if (!app()->runningInConsole()) {
            $integrityFile = resource_path('views/dashboard/attribution.blade.php');
            // Check for 'perprojek.com' signature
            $signature = base64_decode('cGVycHJvamVrLmNvbQ=='); 
            
            if (!file_exists($integrityFile) || strpos(file_get_contents($integrityFile), $signature) === false) {
                // Critical Error
                die('Projek bermasalah karena Anda menghapus file atribusi penting dari kami. Salam, Perprojek.com');
            }
        }
    }
}
